%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CODIFY_CHROMOSOME
%
% Codify the multiple alignment with numbers identifiying: 
% 1) the positions of each amino acids in its sequence.
% 2) the positions of the last amino acid in its sequence (for gaps).
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [chromosome] = codify_chromosome(msa)

% Initialize matrix
chromosome = zeros(size(msa,1),size(msa,2));

% Codify each sequence in the alignment
for i=1:size(msa,1)
    % Codify amino acids
    positions_gaps = msa(i,:) == '*';
    chromosome(i, ~positions_gaps) = 1:sum(~positions_gaps);     
    positions_no_gaps = [1 find(~positions_gaps) length(chromosome(i,:))];
    for j=2:length(positions_no_gaps)
        chromosome(i,positions_no_gaps(j-1)+1:positions_no_gaps(j)-1) = chromosome(i,positions_no_gaps(j-1))*-1;
    end
    
    % Codify gaps
    if(chromosome(i,end) == 0)
        chromosome(i,end) = chromosome(i,positions_no_gaps(end-1))*-1;
    end
end

if(~isequal(abs(chromosome(:,end))', sum(msa'~='*')))
    fprintf('\nAn error has been produced in the codification\n');
    pause;
end

